package com.agilex.healthcare.veteranappointment.validator;


import java.util.Iterator;


public class ValidationResult<T> {
    private ValidationErrors<T> errors = new ValidationErrors();

    public ValidationResult() {
    }

    public ValidationErrors<T> getErrors() {
        return this.errors;
    }

    public boolean isValid() {
        return this.errors.size() == 0;
    }

    public void setRequestObject(T requestObject) {
        this.errors.setRequestObject(requestObject);
    }

    public T getRequestObject() {
        return this.errors.getRequestObject();
    }

    public void addIfNotNull(ValidationError e) {
        if(e != null) {
            this.errors.add(e);
        }

    }

    public void addAll(ValidationErrors<T> list) {
        if(list != null) {
            Iterator i$ = list.iterator();

            while(i$.hasNext()) {
                ValidationError error = (ValidationError)i$.next();
                this.errors.add(error);
            }
        }

    }
}